
//Disable $fn and $fa, do not change these
$fn=0;
$fa=0.01;
$fs=0.5;


basex=19;
basey=25;
basez=2;

end0x=22;
end0z=12;
end0y=1;

end1x=18;
end1z=12;
end1y=1.7;

end2x=22;
end2z=12;
end2y=2;




module base()
{

cube([basex,basey,basez]);

translate([(basex-end0x)/2,-end0y,0])cube([end0x,end0y,end0z]);

translate([(basex-end1x)/2,-end1y-end0y,0])cube([end1x,end1y,end1z]);

translate([(basex-end2x)/2,-end0y-end1y-end2y,0])cube([end2x,end2y,end2z]);
}


padr=1.7;
padh=1;   
padshift=1.7;



module hole()
{
 hy=end0y+end1y+end2y;   
 hx=10;
 hz=8;
 hxshift=(basex-hx)/2;
 hzshift=basez+padh;
 translate([hxshift,-end0y-end1y-end2y,hzshift])cube([hx,hy,hz]);
    
}



module pad(x,y,z)
{
 translate([x,y,z])cylinder(r=padr,h=padh);   
}

module padh(x,y,z)
{
 padholer=0.5;   
 padholeh=padh+basez+1;   
 translate([x,y,z-0.5])cylinder(r=padholer,h=padholeh);   
}



difference()
{
 union()
 {   
  base();
  pad(padshift,padshift,basez);
  pad(basex-padshift,padshift,basez);
  pad(basex-padshift,basey-padshift,basez);
  pad(padshift,basey-padshift,basez);
 }
 union()
 {
  hole();
  padh(padshift,padshift,0);
  padh(basex-padshift,padshift,0);
  padh(basex-padshift,basey-padshift,0);
  padh(padshift,basey-padshift,0);
 }
}