//Disable $fn and $fa, do not change these
$fn=0;
$fa=0.01;
$fs=0.5;

epsilon=0.2;

m3r=1.6;
m3hr=3;
m3hh=2;

raild=3.1;

psud=4;

thickness=4;
thicknessx=6;
rail=30;
side=20;

beamthickness=2;
beamwidth=5-epsilon;
beamlength=50;
beamlength2=160;

points=
[
 [side,thickness,rail],
 [thickness,thickness,rail],
 [thickness,side,rail],
 [side,thickness,rail-thickness],
 [thickness,thickness,rail-thickness],
 [thickness,side,rail-thickness]
];

faces=
[
[0,1,2],
[3,5,4],
[0,2,5,3],
[0,3,4,1],
[2,1,4,5]
];


module nut()
{
    rotate([0,0,30])cylinder(3,r = 5.5 / 2 / cos(180 / 6) + 0.2, $fn=6);
}




module base()
{
    difference()
    {
union()
{
cube([side,thickness,rail]);
cube([thickness,side,rail]);
polyhedron(points,faces);
translate([0,0,-rail+thickness]) polyhedron(points,faces);
    
    
    
}

translate([side/2,thicknessx,5*rail/16])rotate([90,0,0])cylinder(thicknessx,d=raild);    
    
translate([side/2,thicknessx,11*rail/16])rotate([90,0,0])cylinder(thicknessx,d=raild);    


translate([-5*thickness,5*thickness+side-0.6*beamwidth,0])rotate([0,0,-45])
union(){
 cube([beamlength,beamwidth,beamthickness]);
 translate([beamlength-10,beamwidth/2,0])cylinder(thickness,d=raild);    

}

translate([-5*thickness,5*thickness+side-0.6*beamwidth,rail-thickness+beamthickness])rotate([0,0,-45])
union(){
 cube([beamlength,beamwidth,beamthickness]);
 translate([beamlength-10,beamwidth/2,-thickness])cylinder(thickness,d=raild);    

}

}
}



module arm()
{
    difference(){
 cube([beamlength2,beamwidth,beamthickness]);
 translate([beamlength2-10+epsilon,beamwidth/2,0])cylinder(thickness,d=raild);    
 translate([10-epsilon,beamwidth/2,0])cylinder(thickness,d=raild);    



    }

}
sensespace=19.5;
railspace=(rail-sensespace)/2;
boardw=16;
boardl=11;
boardspace=(rail-boardw)/2;


module platform()
{
difference()
{
union()
{
cube([side,thickness,rail]);
cube([thickness,side,rail]);
polyhedron(points,faces);
translate([0,0,-rail+thickness]) polyhedron(points,faces);
    
    
    
}


// sensor bolt holes
translate([(side)/2,thicknessx,railspace])rotate([90,0,0])cylinder(thicknessx,d=raild);    
    
translate([(side)/2,thicknessx,rail-railspace])rotate([90,0,0])cylinder(thicknessx,d=raild);    

// sensor cut outs for nuts

translate([(side)/2,thickness+3,rail-railspace])rotate([90,0,0]) nut();

translate([(side)/2,thickness+3,railspace])rotate([90,0,0]) nut();


// hole for sensor

translate([(side-boardl)/2,0,boardspace])cube([boardl,thickness,boardw]);    



translate([0,(side+thickness)/2,rail/2])rotate([0,90,0])cylinder(thicknessx,d=12);




translate([-5*thickness,5*thickness+side-0.6*beamwidth,0])rotate([0,0,-45])
union(){
 cube([beamlength,beamwidth,beamthickness]);
 translate([beamlength-10,beamwidth/2,0])cylinder(thickness,d=raild);    

}

translate([-5*thickness,5*thickness+side-0.6*beamwidth,rail-thickness+beamthickness])rotate([0,0,-45])
union(){
 cube([beamlength,beamwidth,beamthickness]);
 translate([beamlength-10,beamwidth/2,-thickness])cylinder(thickness,d=raild);    

}


}
}


rotate([90,0,0])base();

translate([-20,-50,0])rotate ([0,0,90])arm();

translate([-40,-50,0]) rotate ([0,0,90])arm();

translate ([40,0,0]) rotate([90,0,0]) platform();
